<?php
// vars: $button_text, $data (array), $use_icon (bool), $icon_url (string)
if (!defined('ABSPATH')) exit;

$json = esc_attr(wp_json_encode($data));
$aria = isset($data['title']) && $data['title'] ? ('Ver ' . $data['title'] . ' en 360') : 'Ver en 360';
?>
<div class="fp360-wrap">
  <button
    class="fp360-open <?php echo !empty($use_icon) ? 'fp360-btn-icon' : ''; ?>"
    type="button"
    data-fp360="<?php echo $json; ?>"
    aria-label="<?php echo esc_attr($aria); ?>"
    title="<?php echo esc_attr($aria); ?>"
  >
    <?php if (!empty($use_icon)): ?>
      <img
        src="<?php echo esc_url($icon_url); ?>"
        alt=""
        width="34" height="34"
        style="width:var(--fp360-icon-size,34px);height:var(--fp360-icon-size,34px);display:block;"
      />
    <?php else: ?>
      <?php echo esc_html($button_text); ?>
    <?php endif; ?>
  </button>
</div>
