<?php
// vars: $active (bool), $key (string)
if (!defined('ABSPATH')) exit;

$assets_base = defined('FP360_ASSETS_URL') ? FP360_ASSETS_URL : plugin_dir_url(dirname(__FILE__)) . 'assets/';
$banner_url  = $assets_base . 'admin/banner.png';
$ver         = defined('FP360_VERSION') ? FP360_VERSION : '1.0.0';

// helper simple para enmascarar la clave si está activa
function fp360_mask_key($k){
  $k = trim((string)$k);
  if ($k === '') return '';
  if (strlen($k) <= 8) return str_repeat('•', strlen($k));
  return substr($k, 0, 4) . str_repeat('•', max(0, strlen($k) - 8)) . substr($k, -4);
}
?>
<div class="wrap fp360-license-page">

  <style>
    /* estilos mínimos, aislados por el scope .fp360-license-page */
    .fp360-license-page .fp360-banner-bleed{margin:0 -20px 16px -20px}
    .fp360-license-page .fp360-banner{display:block;width:100%;height:auto}
    @media (max-width:782px){ .fp360-license-page .fp360-banner-bleed{margin:0 -12px 12px -12px} }

    .fp360-license-page h1{margin-top:12px;margin-bottom:14px}
    .fp360-license-page .fp360-grid{display:grid;grid-template-columns:1fr;gap:16px}
    @media (min-width:1024px){ .fp360-license-page .fp360-grid{grid-template-columns:2fr 1fr} }

    .fp360-license-page .fp360-card{
      background:#fff;border:1px solid #dcdcde;border-radius:8px;padding:16px
    }
    .fp360-license-page .fp360-card h2{margin:.2rem 0 1rem 0;font-size:1.1rem}

    .fp360-license-page .fp360-status{
      display:flex;align-items:center;gap:8px;margin-bottom:8px
    }
    .fp360-license-page .fp360-pill{
      display:inline-block;padding:2px 8px;border-radius:999px;font-size:12px;line-height:18px;border:1px solid #dcdcde;background:#f6f7f7
    }
    .fp360-license-page .fp360-pill.active{background:#e6f6ee;border-color:#b7ebcd;color:#177245}
    .fp360-license-page .fp360-pill.inactive{background:#fff2f0;border-color:#ffccc7;color:#a8071a}

    .fp360-license-page .fp360-kv{margin:.5rem 0;color:#50575e}
    .fp360-license-page .fp360-kv code{background:#f6f7f7;padding:.15em .4em;border-radius:4px}

    .fp360-license-page .fp360-actions{display:flex;gap:8px;flex-wrap:wrap;margin-top:12px}

    .fp360-license-page .fp360-note{
      font-size:12px;color:#50575e;margin-top:10px
    }
    .fp360-license-page .fp360-list{margin:.5rem 0 0 1rem}
    .fp360-license-page .fp360-list li{list-style:disc;margin:.25rem 0}

    /* input ancho */
    .fp360-license-page .fp360-input{max-width:520px}
  </style>

  <!-- banner con bleed lateral -->
  <div class="fp360-banner-bleed">
    <img class="fp360-banner"
         src="<?php echo esc_url($banner_url); ?>?ver=<?php echo esc_attr($ver); ?>"
         alt="fotoproducto 360" />
  </div>

  <h1>Licencia de Photo 360</h1>

  <div class="fp360-grid">
    <div class="fp360-card">
      <?php if (!$active): ?>
        <h2>Activar licencia</h2>

        <div class="fp360-status">
          <span class="fp360-pill inactive">Inactiva</span>
          <span class="fp360-kv">Necesitas activar tu clave para usar todas las funciones</span>
        </div>

        <form method="post" action="">
          <?php wp_nonce_field('fp360_license_action', 'fp360_nonce'); ?>
          <input type="hidden" name="fp360_action" value="activate" />

          <table class="form-table" role="presentation">
            <tr>
              <th scope="row"><label for="fp360_license_key">Tu clave de licencia</label></th>
              <td>
                <input
                  type="text"
                  id="fp360_license_key"
                  name="fp360_license_key"
                  class="regular-text fp360-input"
                  placeholder="pega aquí tu clave"
                  value="<?php echo esc_attr($key); ?>"
                />
                <p class="description">Tras guardar, validaremos la clave.</p>
              </td>
            </tr>
          </table>

          <?php submit_button('Activar licencia'); ?>
        </form>

        <p class="fp360-note">
          ¿No tienes una clave? Contacta con soporte para obtenerla.
        </p>

      <?php else: ?>
        <h2>Licencia activa</h2>

        <div class="fp360-status">
          <span class="fp360-pill active">Activa</span>
          <span class="fp360-kv">La verificación se realiza de forma periódica</span>
        </div>

        <?php if (!empty($key)): ?>
          <div class="fp360-kv">Licencia: <code><?php echo esc_html(fp360_mask_key($key)); ?></code></div>
        <?php endif; ?>

        <div class="fp360-actions">
          <form method="post" action="">
            <?php wp_nonce_field('fp360_license_action', 'fp360_nonce'); ?>
            <input type="hidden" name="fp360_action" value="deactivate" />
            <?php submit_button('Desactivar licencia', 'secondary', 'submit', false); ?>
          </form>
        </div>

        <p class="fp360-note">Si cambias de dominio o servidor, desactiva aquí y vuelve a activar en el nuevo entorno.</p>
      <?php endif; ?>
    </div>

    <div class="fp360-card">
      <h2>Ayuda rápida</h2>
      <ul class="fp360-list">
        <li>La licencia permite usar el visor 360, el widget de elementor y la integración con woocommerce.</li>
        <li>Si tienes problemas de conexión, el sistema aplica un pequeño periodo de gracia antes de desactivar.</li>
        <li>Puedes reactivar la licencia en cualquier momento con la misma clave (si tu plan lo permite).</li>
      </ul>
      <p class="fp360-note">¿Necesitas más ayuda? Ponte en contacto con soporte.</p>
    </div>
  </div>
</div>
