<?php
if (!defined('ABSPATH')) exit;

class FP360_Elementor_Gallery_Widget extends \Elementor\Widget_Base {

  public function get_name() { return 'fp360_gallery_widget'; }
  public function get_title() { return 'Fotoproducto 360 — Galería'; }
  public function get_icon() { return 'eicon-gallery-grid'; }
  public function get_categories() { return ['general']; }

  protected function register_controls() {
    $this->start_controls_section('content', ['label' => 'Contenido']);

    $this->add_control('gallery_id', [
      'label'   => 'ID de la Galería',
      'type'    => \Elementor\Controls_Manager::NUMBER,
      'min'     => 1,
      'step'    => 1,
      'default' => 0,
    ]);

    $this->add_control('button', [
      'label'       => 'Texto del Botón (si no es inline)',
      'type'        => \Elementor\Controls_Manager::TEXT,
      'default'     => 'Ver en 360',
      'placeholder' => 'Ver en 360',
    ]);

    $this->add_control('controls', [
      'label'        => 'Controles (Play/Pause y Arrastre)',
      'type'         => \Elementor\Controls_Manager::SWITCHER,
      'label_on'     => 'Sí',
      'label_off'    => 'No',
      'return_value' => '1',
      'default'      => '',
    ]);

    $this->add_control('inline', [
      'label'        => 'Mostrar Inline (sin Modal)',
      'type'         => \Elementor\Controls_Manager::SWITCHER,
      'label_on'     => 'Sí',
      'label_off'    => 'No',
      'return_value' => '1',
      'default'      => '',
    ]);

    $this->add_control('use_icon', [
      'label'        => 'Mostrar Icono en lugar de Texto',
      'type'         => \Elementor\Controls_Manager::SWITCHER,
      'label_on'     => 'Sí',
      'label_off'    => 'No',
      'return_value' => '1',
      'default'      => '',
      'description'  => 'Solo aplica cuando no es inline (usa el modal).',
    ]);

    $this->end_controls_section();
  }

  protected function render() {
    $id        = (int) $this->get_settings_for_display('gallery_id');
    if ($id <= 0) return;

    $btn       = (string) $this->get_settings_for_display('button');
    $controls  = $this->get_settings_for_display('controls') ? '1' : '0';
    $inline    = $this->get_settings_for_display('inline') ? '1' : '0';
    $use_icon  = $this->get_settings_for_display('use_icon') ? '1' : '0';

    $atts = [
      'id'        => $id,
      'controls'  => $controls,
      'inline'    => $inline,
    ];

    if ($inline !== '1') {
      $atts['button'] = $btn ?: 'Ver en 360';
      if ($use_icon === '1') {
        $atts['icon'] = '1'; // esto activa el icono en el botón del shortcode
      }
    }

    $parts = [];
    foreach ($atts as $k => $v) {
      $parts[] = $k . '="' . esc_attr($v) . '"';
    }
    echo do_shortcode('[fp360_gallery ' . implode(' ', $parts) . ']');
  }
}
