<?php
namespace FP360;

if (!defined('ABSPATH')) exit;

class Utils {
  // http post simple
  public static function http_post($path, $body = [], $timeout = 8) {
    $url = rtrim(FP360_API_BASE, '/') . '/' . ltrim($path, '/');
      // debug bruto (comenta/borra cuando acabes)

    $res = wp_remote_post($url, [
      'timeout' => $timeout,
      'headers' => ['Content-Type' => 'application/json'],
      'body'    => wp_json_encode($body),
    ]);
   
    if (is_wp_error($res)) return $res;
    $code = wp_remote_retrieve_response_code($res);
    $json = json_decode(wp_remote_retrieve_body($res), true);
   
    
    return ['code' => $code, 'json' => $json];
  }

  // obtiene host normalizado
  public static function host() {
    $u = home_url();
    $h = parse_url($u, PHP_URL_HOST);
    return strtolower($h ?: $u);
  }

  // views simples
  public static function view($template, $vars = []) {
    $path = FP360_PATH . 'templates/' . $template;
    if (!file_exists($path)) return;
    extract($vars);
    include $path;
  }

  // sanitiza clave
  public static function clean_key($k) {
    return preg_replace('/[^A-Z0-9\-]/i', '', (string)$k);
  }

  // tiempo actual
  public static function now() {
    return time();
  }
}
