<?php
namespace FP360;

if (!defined('ABSPATH')) exit;

class Kernel {
  public static function boot() {
    Admin::register_menu();

    if (!License::maybe_open_gate()) {
      Admin::register_license_page();
      add_action('admin_notices', ['FP360\\Admin', 'license_notice']);
      return;
    }

    Admin::register_license_page();

    require_once FP360_PATH . 'includes/Galleries.php';
    Galleries::register();

    require_once FP360_PATH . 'includes/Elementor.php';
    Elementor::register();

    require_once FP360_PATH . 'includes/WC.php';
    WC::register();
  }
}
