<?php
namespace FP360;

if (!defined('ABSPATH')) exit;

class Elementor {
  // engancha siempre al hook de elementor; se ejecutará cuando elementor esté listo
  public static function register() {
    add_action('elementor/widgets/register', [__CLASS__, 'register_widgets']);
  }

  // carga widgets y los registra cuando elementor invoque el hook
  public static function register_widgets($widgets_manager) {
    // widget de galerías (ya existente)
    if (!class_exists('\\FP360_Elementor_Gallery_Widget', false)) {
      require_once FP360_PATH . 'includes/elementor-widget-gallery.php';
    }
    if (class_exists('\\FP360_Elementor_Gallery_Widget')) {
      if (method_exists($widgets_manager, 'register')) {
        $widgets_manager->register(new \FP360_Elementor_Gallery_Widget());
      } else {
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \FP360_Elementor_Gallery_Widget());
      }
    }

    // widget de producto woocommerce (nuevo)
    if (!class_exists('\\FP360_Elementor_WC_Product_Widget', false)) {
      require_once FP360_PATH . 'includes/elementor-widget-wc-product.php';
    }
    if (class_exists('\\FP360_Elementor_WC_Product_Widget')) {
      if (method_exists($widgets_manager, 'register')) {
        $widgets_manager->register(new \FP360_Elementor_WC_Product_Widget());
      } else {
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \FP360_Elementor_WC_Product_Widget());
      }
    }
  }
}
