<?php
namespace FP360;

if (!defined('ABSPATH')) exit;

class Admin {

  // registra el menú principal y el submenú de licencia
  public static function register_menu() {
    // prioridad 9 para que nuestro submenú quede antes que el del CPT
    add_action('admin_menu', function() {
      // menú padre
      add_menu_page(
        'Photo 360',
        'Photo 360',
        'manage_options',
        'fp360',
        ['FP360\\Admin', 'render_license_page'],
        'dashicons-format-gallery',
        56
      );

      // submenú "Licencia" apuntando al mismo slug del padre
      add_submenu_page(
        'fp360',
        'Licencia',
        'Licencia',
        'manage_options',
        'fp360', // mismo slug que el padre
        ['FP360\\Admin', 'render_license_page']
      );

      // opcional: puedes añadir más submenús propios aquí en el futuro
      // el submenú "Galerías" lo añade automáticamente el CPT
      // al tener show_in_menu => 'fp360' en FP360\Galleries::register_cpt()
    }, 9);
  }

  // aviso si no está activa
  public static function license_notice() {
    if (!current_user_can('manage_options')) return;
    if (License::is_active_cached()) return;
    echo '<div class="notice notice-warning"><p>fotoproducto 360 necesita una licencia activa.</p></div>';
  }

  // registra manejo del form
  public static function register_license_page() {
    add_action('admin_init', ['FP360\\Admin', 'handle_license_form']);
  }

  // procesa el formulario
  public static function handle_license_form() {
    if (!current_user_can('manage_options')) return;
    if (!isset($_POST['fp360_action'])) return;
    if (!check_admin_referer('fp360_license_action', 'fp360_nonce')) return;

    $action = sanitize_text_field($_POST['fp360_action']);

    if ($action === 'activate') {
      $key = isset($_POST['fp360_license_key']) ? sanitize_text_field($_POST['fp360_license_key']) : '';
      $res = License::activate($key);
      if ($res['ok']) {
        add_settings_error('fp360', 'fp360_ok', 'licencia activada', 'updated');
      } else {
        add_settings_error('fp360', 'fp360_err', $res['msg'] ?: 'error al activar', 'error');
      }
    }

    if ($action === 'deactivate') {
      License::deactivate_local();
      add_settings_error('fp360', 'fp360_ok', 'licencia desactivada', 'updated');
    }

    // evita reenvío con F5
    wp_redirect(add_query_arg(['page' => 'fp360'], admin_url('admin.php')));
    exit;
  }

  // render de la página de licencia
  public static function render_license_page() {
    if (!current_user_can('manage_options')) return;

    settings_errors('fp360');

    if (!empty($_GET['reset'])) {
      echo '<div class="notice notice-success is-dismissible"><p>licencia borrada. introduce una nueva clave para activar.</p></div>';
    }

    Utils::view('license-page.php', [
      'active' => License::is_active_cached(),
      'key'    => License::stored_key(),
    ]);
  }
}
