<?php
/**
 * Plugin Name: Photo360
 * Description: Visores 360 de productos
 * Version: 1.1.2
 * Author: PlanetaDominio
 * Author URI: https://fotoproductoestudio.com
 */

if (!defined('ABSPATH')) exit;

// constantes básicas
define('FP360_VERSION', '1.0.0');
define('FP360_FILE', __FILE__);
define('FP360_PATH', plugin_dir_path(__FILE__));
define('FP360_URL', plugin_dir_url(__FILE__));
define('FP360_ASSETS_URL', FP360_URL . 'assets/');
define('FP360_API_BASE', 'https://licencias.takeoffcomunicacion.es/api'); 

// nombres de opciones/transients
define('FP360_OPT_LICENSE_KEY',     'fp360_license_key');
define('FP360_OPT_LICENSE_SECRET',  'fp360_license_secret');
define('FP360_OPT_LICENSE_DOMAIN',  'fp360_license_domain');
define('FP360_TRANS_LICENSE_STATE', 'fp360_license_state'); 

// carga de módulos
require_once FP360_PATH . 'includes/Utils.php';
require_once FP360_PATH . 'includes/License.php';
require_once FP360_PATH . 'includes/Admin.php';
require_once FP360_PATH . 'includes/Kernel.php';

// arranque
add_action('plugins_loaded', ['FP360\\Kernel', 'boot']);
