(function($){
  // helpers
  function updateHiddenFromList($list, $hidden){
    var ids = [];
    $list.find('li').each(function(){ ids.push(String($(this).data('id'))); });
    $hidden.val(ids.join(','));
  }

  // --- bloque GALERÍAS (ya existente) ---
  $(document).on('click', '#fp360-gallery-add', function(e){
    e.preventDefault();
    var frame = wp.media({ title:'selecciona imágenes 360', library:{type:'image'}, multiple:true, button:{text:'añadir'} });
    frame.on('select', function(){
      var ids = $('#fp360-gallery-ids').val().split(',').filter(Boolean);
      frame.state().get('selection').each(function(att){
        var a = att.toJSON();
        ids.push(String(a.id));
        $('#fp360-gallery-list').append('<li data-id="'+a.id+'"><img src="'+a.sizes.thumbnail.url+'"><span class="fp360-remove">x</span></li>');
      });
      $('#fp360-gallery-ids').val(ids.join(','));
    });
    frame.open();
  });

  $(document).on('click', '#fp360-gallery-list .fp360-remove', function(){
    var $li = $(this).closest('li');
    var id = String($li.data('id'));
    $li.remove();
    var ids = $('#fp360-gallery-ids').val().split(',').filter(Boolean).filter(function(x){return x!==id;});
    $('#fp360-gallery-ids').val(ids.join(','));
  });

  $(function(){
    $('#fp360-gallery-list').sortable({
      update: function(){
        updateHiddenFromList($('#fp360-gallery-list'), $('#fp360-gallery-ids'));
      }
    });
  });

  // invertir orden en galerías
  $(document).on('click', '#fp360-gallery-invert', function(){
    var $list = $('#fp360-gallery-list');
    var $items = $list.children('li').get().reverse();
    $list.empty().append($items);
    updateHiddenFromList($list, $('#fp360-gallery-ids'));
  });

  // ordenar por nombre en galerías
  $(document).on('click', '#fp360-gallery-sort-name', function(){
    console.log('Botón ordenar por nombre clickeado (galerías)');
    
    var $list = $('#fp360-gallery-list');
    var $items = $list.children('li');
    
    if ($items.length === 0) {
      console.log('No hay items para ordenar en galerías');
      return;
    }
    
    console.log('Items encontrados en galerías:', $items.length);
    
    // crear array con items y sus datos
    var itemsData = [];
    $items.each(function(){
      var $item = $(this);
      var id = $item.data('id');
      itemsData.push({
        id: id,
        element: $item.clone(),
        name: '' // se llenará con AJAX
      });
    });
    
    // hacer petición AJAX para obtener nombres de archivos
    var ids = itemsData.map(function(item){ return item.id; });
    console.log('IDs a procesar (galerías):', ids);
    
    // usar la variable localizada de WordPress para AJAX
    var ajaxUrl = typeof fp360_ajax !== 'undefined' ? fp360_ajax.ajaxurl : 
                  (typeof ajaxurl !== 'undefined' ? ajaxurl : '/wp-admin/admin-ajax.php');
    var nonce = typeof fp360_ajax !== 'undefined' ? fp360_ajax.nonce : 
                $('#fp360-gallery-box input[name="fp360_gallery_nonce"]').val();
    
    console.log('AJAX URL (galerías):', ajaxUrl);
    console.log('Nonce (galerías):', nonce);
    
    $.post(ajaxUrl, {
      action: 'fp360_get_attachment_names',
      ids: ids,
      nonce: nonce
    })
    .done(function(response){
      console.log('Respuesta AJAX (galerías):', response);
      
      if (response.success && response.data) {
        // asignar nombres a los items
        itemsData.forEach(function(item){
          item.name = response.data[item.id] || 'z_' + item.id; // fallback si no hay nombre
        });
        
        console.log('Items con nombres (galerías):', itemsData);
        
        // ordenar por nombre
        itemsData.sort(function(a, b){
          return a.name.toLowerCase().localeCompare(b.name.toLowerCase());
        });
        
        console.log('Items ordenados (galerías):', itemsData.map(function(item){ return item.name; }));
        
        // reordenar en el DOM
        $list.empty();
        itemsData.forEach(function(item){
          $list.append(item.element);
        });
        
        updateHiddenFromList($list, $('#fp360-gallery-ids'));
        console.log('Reordenamiento completado (galerías)');
      } else {
        console.error('Error en respuesta AJAX (galerías):', response);
        alert('Error: No se pudieron obtener los nombres de los archivos');
      }
    })
    .fail(function(xhr, status, error){
      console.error('Error AJAX (galerías):', status, error);
      console.error('Respuesta completa (galerías):', xhr.responseText);
      alert('Error de conexión: ' + error);
    });
  });

  // --- bloque PRODUCTO (nuevo, sin romper lo anterior) ---
  $(document).on('click', '#fp360p-add', function(e){
    e.preventDefault();
    var frame = wp.media({ title:'selecciona imágenes 360', library:{type:'image'}, multiple:true, button:{text:'añadir'} });
    frame.on('select', function(){
      var ids = $('#fp360p-ids').val().split(',').filter(Boolean);
      frame.state().get('selection').each(function(att){
        var a = att.toJSON();
        ids.push(String(a.id));
        $('#fp360p-list').append('<li data-id="'+a.id+'"><img src="'+a.sizes.thumbnail.url+'"><span class="fp360-remove">x</span></li>');
      });
      $('#fp360p-ids').val(ids.join(','));
    });
    frame.open();
  });

  // eliminar item en producto
  $(document).on('click', '#fp360p-list .fp360-remove', function(){
    var $li = $(this).closest('li');
    var id = String($li.data('id'));
    $li.remove();
    var ids = $('#fp360p-ids').val().split(',').filter(Boolean).filter(function(x){return x!==id;});
    $('#fp360p-ids').val(ids.join(','));
  });

  // ordenar en producto
  $(function(){
    $('#fp360p-list').sortable({
      update: function(){
        updateHiddenFromList($('#fp360p-list'), $('#fp360p-ids'));
      }
    });
  });

  // invertir orden en producto
  $(document).on('click', '#fp360p-invert', function(){
    var $list = $('#fp360p-list');
    var $items = $list.children('li').get().reverse();
    $list.empty().append($items);
    updateHiddenFromList($list, $('#fp360p-ids'));
  });

  // ordenar por nombre en producto
  $(document).on('click', '#fp360p-sort-name', function(){
    console.log('Botón ordenar por nombre clickeado');
    
    var $list = $('#fp360p-list');
    var $items = $list.children('li');
    
    if ($items.length === 0) {
      console.log('No hay items para ordenar');
      return;
    }
    
    console.log('Items encontrados:', $items.length);
    
    // crear array con items y sus datos
    var itemsData = [];
    $items.each(function(){
      var $item = $(this);
      var id = $item.data('id');
      itemsData.push({
        id: id,
        element: $item.clone(),
        name: '' // se llenará con AJAX
      });
    });
    
    // hacer petición AJAX para obtener nombres de archivos
    var ids = itemsData.map(function(item){ return item.id; });
    console.log('IDs a procesar:', ids);
    
    // usar la variable localizada de WordPress para AJAX
    var ajaxUrl = typeof fp360_ajax !== 'undefined' ? fp360_ajax.ajaxurl : 
                  (typeof ajaxurl !== 'undefined' ? ajaxurl : '/wp-admin/admin-ajax.php');
    var nonce = typeof fp360_ajax !== 'undefined' ? fp360_ajax.nonce : 
                $('#fp360p-box input[name="fp360_wc_nonce"]').val();
    
    console.log('AJAX URL:', ajaxUrl);
    console.log('Nonce:', nonce);
    
    $.post(ajaxUrl, {
      action: 'fp360_get_attachment_names',
      ids: ids,
      nonce: nonce
    })
    .done(function(response){
      console.log('Respuesta AJAX:', response);
      
      if (response.success && response.data) {
        // asignar nombres a los items
        itemsData.forEach(function(item){
          item.name = response.data[item.id] || 'z_' + item.id; // fallback si no hay nombre
        });
        
        console.log('Items con nombres:', itemsData);
        
        // ordenar por nombre
        itemsData.sort(function(a, b){
          return a.name.toLowerCase().localeCompare(b.name.toLowerCase());
        });
        
        console.log('Items ordenados:', itemsData.map(function(item){ return item.name; }));
        
        // reordenar en el DOM
        $list.empty();
        itemsData.forEach(function(item){
          $list.append(item.element);
        });
        
        updateHiddenFromList($list, $('#fp360p-ids'));
        console.log('Reordenamiento completado');
      } else {
        console.error('Error en respuesta AJAX:', response);
        alert('Error: No se pudieron obtener los nombres de los archivos');
      }
    })
    .fail(function(xhr, status, error){
      console.error('Error AJAX:', status, error);
      console.error('Respuesta completa:', xhr.responseText);
      alert('Error de conexión: ' + error);
    });
  });

})(jQuery);
